Rem ExportAllStories.vbs
Rem An InCopy VBScript
Rem
Rem Exports all stories in an InCopy document in a specified text format.
Rem InCopy will export each story as a separate file, and will name each
Rem file with the ID of the story (each ID is unique within a document).
Rem
main
Function main()
	Set myInCopy = CreateObject("InCopy.Application.2021")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInCopy.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInCopy.Documents.Count > 0 Then
	    If myInCopy.ActiveDocument.Stories.Count > 0 Then
	        myDisplayDialog myInCopy
	    Else
	        MsgBox ("The active document does not contain any text. Please open a document containing text and try again.")
	    End If
	Else
	    MsgBox ("No documents are open. Please open a document and try again.")
	End If
End Function
Function myDisplayDialog(myInCopy)
    Set myDialog = myInCopy.Dialogs.Add
    myDialog.Name = "ExportAllStories"
    With myDialog
        Rem Add a dialog column.
        With .DialogColumns.Add
            With .BorderPanels.Add
                With .StaticTexts.Add
                    .StaticLabel = "Export as:"
                End With
                Set myExportFormatButtons = .RadiobuttonGroups.Add
                With myExportFormatButtons
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Text Only"
                        .CheckedState = True
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "RTF"
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "InCopy Tagged Text"
                    End With
                End With
            End With
        End With
    End With
    myReturn = myDialog.Show
    If myReturn = True Then
        Rem Get the values from the dialog box.
        myExportFormat = myExportFormatButtons.SelectedButton
        myDialog.Destroy
        Rem Creating a folder browser in VBScript can be difficult,
        Rem So we'll use InCopy's built-in JavaScript to display a
        Rem file browser.
        myJavaScript = "myFolder = Folder.selectDialog(""Choose a Folder"");app.activeDocument.insertLabel(""TargetFolder"", myFolder.fsName);"
        myInCopy.DoScript myJavaScript, idScriptLanguage.idJavascript
        Rem Now get the stored folder path from the label.
        myFolder = myInCopy.ActiveDocument.ExtractLabel("TargetFolder")
        Rem Now get the stored folder path from the label.
        myFolder = myInCopy.ActiveDocument.ExtractLabel("TargetFolder")
        If ((myFolder <> "") And (myInCopy.ActiveDocument.Stories.Count <> 0)) Then
            myExportAllStories myInCopy, myExportFormat, myFolder
        End If
    Else
        myDialog.Destroy
    End If
End Function
Rem myExportStories function takes care of exporting the stories.
Rem myExportFormat is a number from 0-2, where 0 = text only, 1 = rtf, and 3 = tagged text.
Rem myFolder is the path to the folder in which you want to save your files.
Function myExportAllStories(myInCopy, myExportFormat, myFolder)
    For myCounter = 1 To myInCopy.ActiveDocument.Stories.Count
        Set myStory = myInCopy.ActiveDocument.Stories.Item(myCounter)
        myID = myStory.Id
        Select Case myExportFormat
            Case 0:
                myFormat = idExportFormat.idTextType
                myExtension = ".txt"
            Case 1:
                myFormat = idExportFormat.idRTF
                myExtension = ".rtf"
            Case 2:
                myFormat = idExportFormat.idTaggedText
                myExtension = ".txt"
        End Select
        Rem DoScript(Script, [Language As idScriptLanguage = idUnknown])
        myFilePath = myFolder & "/" & "StoryID" & myID & myExtension
        myStory.Export myFormat, myFilePath
    Next
End Function

'' SIG '' Begin signature block
'' SIG '' MIIeUwYJKoZIhvcNAQcCoIIeRDCCHkACAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' AhVrWQ4BHjk3xtY/Knipg4nW38F+f1/CLhL1FRvX/ROg
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQB3XcWt35KITbGdVVTAfs
'' SIG '' STANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTE5
'' SIG '' MDEzMTAwMDAwMFoXDTIxMDIwMzEyMDAwMFowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIiKXEE3
'' SIG '' 5FJAWPRPxAu4g1GRRZmzrPW3SZL40s8opqkFWksx2dBE
'' SIG '' yP6+N6visRXUyDy+I979oO9tEtHBeYKx1XHy4NOLPl3u
'' SIG '' Lr8rWv5E3hrNw+QRwJvsMJLzBTS44811Rym8ddkt8lpj
'' SIG '' dG1PmC2aZQ73miR88+46IaZDtuabo3corXvrG0wmLFZb
'' SIG '' SrB80HAigwQiwHgh33cI2pPIYA2VdmEv5V3iI+AuYybL
'' SIG '' BPJ32YPqdvcoR3Ml/oYFcFlUb1sliNdngwqEeUTKBWVu
'' SIG '' OTeuRo2gOioizpUxR3cce25eoH8wONWUozkjPwcUEY8I
'' SIG '' RCePRf21c4kjjLGFSmpwEVQVQJcCAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBSVoz2+cIajBhNjiGb0VJBYxDX9vzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEADtCQA7go0Xu2UKN6dFPe
'' SIG '' YJbS/OXx3n3IP0K9CGPDozeGV62MvbCp+DuptFa44FYR
'' SIG '' ZuljRXMxCjsjJmkJLD9Hhuik+a23iSwfOAnWK6AY/VoD
'' SIG '' ZatWvGG6mZzMRs/s5Whztt8IRxLMrLbA+ulDkDKTlqqf
'' SIG '' BWN8xAM23VX2IMmPYFXMf1TgyT3rCr2oontG6eWT0VYa
'' SIG '' j8DrYJuWtoNQaHIxSg3lGWyvqi1RwJc7GjVwJObnRCTH
'' SIG '' Faqmfxwry/5jEDjPNNUyDiMWIr2xxCbe5pu759mb9Hjl
'' SIG '' rSakmU9AhIxEURqKA3wmnF9Sw+OnazRGp4bvfkCeWDtK
'' SIG '' LdN4JKj5eh21hDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCERcwghETAgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAd13Frd+SiE2xnVVUwH7Ekw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIA3qhIiR72Gh
'' SIG '' pzzQlry+KBrZVFtzTw5iW+9Cn8lOQV+8MDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEASRVdL9Hj
'' SIG '' ca0B2dMlnyxh4Pz8dxg6toth9sGHN/Dl1dqpTHeIJRXo
'' SIG '' GVSFIDL4hR22WMHC3YaNbXTY+grIoa+y4P9DOzdXvzEv
'' SIG '' ecFZhh/QRnUdC/L3a4kClRRyhjhi9j54z3FJXTuA24FR
'' SIG '' KogSC0+k217V7qGwyaOvTTDHudTthXWhRnsj1W3Viwnt
'' SIG '' Tbbd3kT5VgpbjQn0Di8kUS3zp4GvSubLATudz6SvMejt
'' SIG '' HSJZRbHLteCffQOBa6vIm2iLEHfMHqaMqbMiqM61NLrv
'' SIG '' UHLCzxgMFb527pHOfh++9kz8kSuytdF9Hb7+7PT8rsXZ
'' SIG '' WXzxyyQH1z9azN2Hy0OtrNEqOqGCDsgwgg7EBgorBgEE
'' SIG '' AYI3AwMBMYIOtDCCDrAGCSqGSIb3DQEHAqCCDqEwgg6d
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAwdwYLKoZIhvcNAQkQ
'' SIG '' AQSgaARmMGQCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCC+jyRNwf+nlH5bfHyxMYq+sadHlJeeXyCt
'' SIG '' KihN1ve9GAIQXP3DsX8kcWxhNjuvw0cngRgPMjAyMDEw
'' SIG '' MDQwMDIxMDVaoIILuzCCBoIwggVqoAMCAQICEATNP4Vo
'' SIG '' rnbGG7D+cWDMp20wDQYJKoZIhvcNAQELBQAwcjELMAkG
'' SIG '' A1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZ
'' SIG '' MBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UE
'' SIG '' AxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVz
'' SIG '' dGFtcGluZyBDQTAeFw0xOTEwMDEwMDAwMDBaFw0zMDEw
'' SIG '' MTcwMDAwMDBaMEwxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
'' SIG '' Ew5EaWdpQ2VydCwgSW5jLjEkMCIGA1UEAxMbVElNRVNU
'' SIG '' QU1QLVNIQTI1Ni0yMDE5LTEwLTE1MIIBIjANBgkqhkiG
'' SIG '' 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6WQ1nPqpmGVkG+QX
'' SIG '' 3LgpNsxnCViFTTDgyf/lOzwRKFCvBzHiXQkYwvaJjGkI
'' SIG '' BCPgdy2dFeW46KFqjv/UrtJ6Fu/4QbUdOXXBzy+nrEV+
'' SIG '' lG2sAwGZPGI+fnr9RZcxtPq32UI+p1Wb31pPWAKoMmki
'' SIG '' E76Lgi3GmKtrm7TJ8mURDHQNsvAIlnTE6LJIoqEUpfj6
'' SIG '' 4YlwRDuN7/uk9MO5vRQs6wwoJyWAqxBLFhJgC2kijE7N
'' SIG '' xtWyZVkh4HwsEo1wDo+KyuDT17M5d1DQQiwues6cZ3o4
'' SIG '' d1RA/0+VBCDU68jOhxQI/h2A3dDnK3jqvx9wxu5CFlM2
'' SIG '' RZtTGUlinXoCm5UUowIDAQABo4IDODCCAzQwDgYDVR0P
'' SIG '' AQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/
'' SIG '' BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCC
'' SIG '' AaEGCWCGSAGG/WwHATCCAZIwKAYIKwYBBQUHAgEWHGh0
'' SIG '' dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwggFkBggr
'' SIG '' BgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABv
'' SIG '' AGYAIAB0AGgAaQBzACAAQwBlAHIAdABpAGYAaQBjAGEA
'' SIG '' dABlACAAYwBvAG4AcwB0AGkAdAB1AHQAZQBzACAAYQBj
'' SIG '' AGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAA
'' SIG '' RABpAGcAaQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABh
'' SIG '' AG4AZAAgAHQAaABlACAAUgBlAGwAeQBpAG4AZwAgAFAA
'' SIG '' YQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBo
'' SIG '' AGkAYwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwA
'' SIG '' aQB0AHkAIABhAG4AZAAgAGEAcgBlACAAaQBuAGMAbwBy
'' SIG '' AHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
'' SIG '' eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9
'' SIG '' bAMVMB8GA1UdIwQYMBaAFPS24SAd/imu0uRhpbKiJbLI
'' SIG '' FzVuMB0GA1UdDgQWBBRWUw/BxgenTdfYbldygFBM5Oye
'' SIG '' wTBxBgNVHR8EajBoMDKgMKAuhixodHRwOi8vY3JsMy5k
'' SIG '' aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLXRzLmNybDAy
'' SIG '' oDCgLoYsaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3No
'' SIG '' YTItYXNzdXJlZC10cy5jcmwwgYUGCCsGAQUFBwEBBHkw
'' SIG '' dzAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNl
'' SIG '' cnQuY29tME8GCCsGAQUFBzAChkNodHRwOi8vY2FjZXJ0
'' SIG '' cy5kaWdpY2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJl
'' SIG '' ZElEVGltZXN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEB
'' SIG '' CwUAA4IBAQAug6FEBUoE47kyUvrZgfAau/gJjSO5PdiS
'' SIG '' oeZGHEovbno8Y243F6Mav1gjskOclINOOQmwLOjH4eLM
'' SIG '' 7ct5a87eIwFH7ZVUgeCAexKxrwKGqTpzav74n8GN0SGM
'' SIG '' 5CmCw4oLYAACnR9HxJ+0CmhTf1oQpvgi5vhTkjFf2IKD
'' SIG '' LW0TQq6DwRBOpCT0R5zeDyJyd1x/T+k5mCtXkkTX726T
'' SIG '' 2UPHBDNjUTdWnkcEEcOjWFQh2OKOVtdJP1f8Cp8jXnv0
'' SIG '' lI3dnRq733oqptJFplUMj/ZMivKWz4lG3DGykZCjXzMw
'' SIG '' YFX1/GswrKHt5EdOM55naii1TcLtW5eC+MupCGxTCbT3
'' SIG '' MIIFMTCCBBmgAwIBAgIQCqEl1tYyG35B5AXaNpfCFTAN
'' SIG '' BgkqhkiG9w0BAQsFADBlMQswCQYDVQQGEwJVUzEVMBMG
'' SIG '' A1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
'' SIG '' ZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBB
'' SIG '' c3N1cmVkIElEIFJvb3QgQ0EwHhcNMTYwMTA3MTIwMDAw
'' SIG '' WhcNMzEwMTA3MTIwMDAwWjByMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2Vy
'' SIG '' dCBTSEEyIEFzc3VyZWQgSUQgVGltZXN0YW1waW5nIENB
'' SIG '' MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
'' SIG '' vdAy7kvNj3/dqbqCmcU5VChXtiNKxA4HRTNREH3Q+X1N
'' SIG '' aH7ntqD0jbOI5Je/YyGQmL8TvFfTw+F+CNZqFAA49y4e
'' SIG '' O+7MpvYyWf5fZT/gm+vjRkcGGlV+Cyd+wKL1oODeIj8O
'' SIG '' /36V+/OjuiI+GKwR5PCZA207hXwJ0+5dyJoLVOOoCXFr
'' SIG '' 4M8iEA91z3FyTgqt30A6XLdR4aF5FMZNJCMwXbzsPGBq
'' SIG '' rC8HzP3w6kfZiFBe/WZuVmEnKYmEUeaC50ZQ/ZQqLKfk
'' SIG '' dT66mA+Ef58xFNat1fJky3seBdCEGXIX8RcG7z3N1k3v
'' SIG '' BkL9olMqT4UdxB08r8/arBD13ays6Vb/kwIDAQABo4IB
'' SIG '' zjCCAcowHQYDVR0OBBYEFPS24SAd/imu0uRhpbKiJbLI
'' SIG '' FzVuMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3z
'' SIG '' bcgPMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/
'' SIG '' BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHkGCCsG
'' SIG '' AQUFBwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29j
'' SIG '' c3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
'' SIG '' Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
'' SIG '' c3N1cmVkSURSb290Q0EuY3J0MIGBBgNVHR8EejB4MDqg
'' SIG '' OKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20vRGln
'' SIG '' aUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRo
'' SIG '' dHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
'' SIG '' c3N1cmVkSURSb290Q0EuY3JsMFAGA1UdIARJMEcwOAYK
'' SIG '' YIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczov
'' SIG '' L3d3dy5kaWdpY2VydC5jb20vQ1BTMAsGCWCGSAGG/WwH
'' SIG '' ATANBgkqhkiG9w0BAQsFAAOCAQEAcZUS6VGHVmnN793a
'' SIG '' fKpjerN4zwY3QITvS4S/ys8DAv3Fp8MOIEIsr3fzKx8M
'' SIG '' IVoqtwU0HWqumfgnoma/Capg33akOpMP+LLR2HwZYuhe
'' SIG '' giUexLoceywh4tZbLBQ1QwRostt1AuByx5jWPGTlH0gQ
'' SIG '' GF+JOGFNYkYkh2OMkVIsrymJ5Xgf1gsUpYDXEkdws3XV
'' SIG '' k4WTfraSZ/tTYYmo9WuWwPRYaQ18yAGxuSh1t5ljhSKM
'' SIG '' Ycp5lH5Z/IwP42+1ASa2bKXuh1Eh5Fhgm7oMLSttosR+
'' SIG '' u8QlK0cCCHxJrhO24XxCQijGGFbPQTS2Zl22dHv1VjMi
'' SIG '' LyI2skuiSpXY9aaOUjGCAk0wggJJAgEBMIGGMHIxCzAJ
'' SIG '' BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
'' SIG '' GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNV
'' SIG '' BAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBUaW1l
'' SIG '' c3RhbXBpbmcgQ0ECEATNP4VornbGG7D+cWDMp20wDQYJ
'' SIG '' YIZIAWUDBAIBBQCggZgwGgYJKoZIhvcNAQkDMQ0GCyqG
'' SIG '' SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDEwMDQw
'' SIG '' MDIxMDVaMCsGCyqGSIb3DQEJEAIMMRwwGjAYMBYEFAMl
'' SIG '' vVBe2pYwLcIvT6AeTCi+KDTFMC8GCSqGSIb3DQEJBDEi
'' SIG '' BCAchyscI88fLXXNK9SPal8N44lRDHsECogfsEjA9lL/
'' SIG '' AjANBgkqhkiG9w0BAQEFAASCAQDHTeO6T40/dYZnAcs2
'' SIG '' oIVuP0UxaEM+v5Vy4O08kd8uyhfB92kcnk2v6zR2aOWY
'' SIG '' zx94iCRUPcbz4PBioSDlLk40USOU6y3xmKwNQDfc94Ie
'' SIG '' Hz8VWYj/ykZEopOrTw8XKkVJ4otghcygjYE+zti0x4Es
'' SIG '' 2zRCDuLnr7vL4dIQpxvx0Wsz32Zvt0xmnTwR5611YrYV
'' SIG '' PsAb9mW0FlC4jeyjqhsOOXmnmOzjh1Mm1+bf9atjfTZf
'' SIG '' dzdabcDDKL2gCQyTBZ3RxXPDpkJDqC9aQvNmdYsoqFek
'' SIG '' mCza6p8odlVqALyKyTMDgcYtygUrrA8RnyzUu0LC5DQk
'' SIG '' ZyOm2lsJSH7Q2x+U
'' SIG '' End signature block
